////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Ici est un extrait d'un code source du logiciel
//
////////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Mthode permettant de calculer le nombre de lignes d'un fichier texte (les fichiers *.csv sont des exemples)
//
////////////////////////////////////////////////////////////////////////////////////////////////////

int CScop32Doc::getLignes(CString cstrFichierEv)
{
	int count = 0;
	string ligne;
	// Ouverture du fichier de donnes
	fstream fsource(cstrFichierEv, ios_base::in);
    
	// Test si le fichier est bien ouvert
	if (fsource.is_open())
	{
		while (!fsource.eof())
		{
 			getline(fsource, ligne); //lire le fichier de donnes ligne par ligne
			count++;
		}
		fsource.close();
	}
	return count;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Mthode permettant de traiter le fichier ayant le nom "cstrFichierEv" (de taille environ 450Mo)
// "dossierAngleTrie" est le nom du rpertoire o le traitement va crer des sous-rpertoires et des petits fichiers ayant le format spcifique
//
////////////////////////////////////////////////////////////////////////////////////////////////////
BOOL CScop32Doc::ImportUTWINAngle(CString cstrFichierEv,CString dossierAngleTrie)
{
	int ligneIndex = 0,
		totalLignes = getLignes(cstrFichierEv);
	string ligne,
		   nomFichierParam = dossierAngleTrie + "paremetre.csv",
		   repertoireAngle,
		   nomFichierSignal,
		   chemin,
		   chaine,
		   cheminFichierSignal;
	float angle,
		distance,
		point,
		duree,
		frequence;
	short *pDonneesEv;
	char *pEnteteFichEv;
	int nPtAcq,
		m_nVoie = 1;
	CDlgProgress DlgProgress;

	if (DlgProgress.DoModal() == IDOK) {
			// Ouverture du fichier de donnes
			fstream fsource(cstrFichierEv, ios_base::in);
	    
			// Test si le fichier est bien ouvert
			if (fsource.is_open())
			{    
				// j'ai essay les mthodes SetRange, SetPos, StepIt ... de ma classe ProgressCtrl
				// mais a n'a pas march, j'ai remplac par ces mthodes du coup 
				SendMessage(DlgProgress.m_progress, PBM_SETRANGE, 0, MAKELPARAM(0, totalLignes));
				SendMessage(DlgProgress.m_progress, PBM_SETSTEP, (WPARAM) 1, 0);

				// Creation d'un fichier contenant des paramtres de scanning 
				ofstream fparam(nomFichierParam.c_str());
				
				while (!fsource.eof() && angle < 2)
				{
					getline(fsource, ligne); //lire le fichier de donnes ligne par ligne

					// Test si le fichier contenant des paramtres de scanning est bien ouvert
					if (fparam.is_open())
					{
						// Enregistrement des donnes de paremtres dans un fichier  part
						if (ligneIndex < 42) fparam << ligne << endl;
						
						// Extraction la frquence
						if (ligneIndex == 41) 
						{
							istringstream issLigne(ligne,istringstream::in);
							while ( std::getline( issLigne, chaine, ' ' ) )
							{
								if (is_float(chaine)) {
									std::istringstream issChaine(chaine);
									issChaine >> frequence;
								}
							}
						}

						// Extraction la duree
						if (ligneIndex == 10) 
						{
							istringstream issLigne(ligne,istringstream::in);
							while ( std::getline( issLigne, chaine, ' ' ) )
							{
								if (is_float(chaine)) {
									std::istringstream issChaine(chaine);
									issChaine >> duree;
								}
							}
						}
						
					}	
					
					// Les signaux sont stock  partir de la ligne 45 
					if (ligneIndex >= 45)
					{
						// Fermeture du fichier contenant des paramtres de scanning
						fparam.close();

						// Creation des flux de string permettant de manipuler les lignes lues depuis le fichier de donnes
						istringstream iss(ligne,istringstream::in);
						std::ostringstream oss;

						// Interpretation des lignes
						iss >> angle;
						oss << angle*5+5 << "";
						std::string repertoireAngle = oss.str();

						iss >> distance;
						oss << distance*2+2 << "mm";
						std::string nomFichierSignal = oss.str();

						// Le chemin du rpertoire dans lequel seront enregistrs les dossiers de signaux de chaque angle
						chemin = dossierAngleTrie + repertoireAngle.c_str();
						
						// Cration de chaque rpertoire contenant des signaux ayant la meme angle
						mkdir(chemin.c_str());
						
						// Le chemin de chaque fichier reprsente d'un signal
						cheminFichierSignal = chemin + "/" + nomFichierSignal + ".pro";
						
						
						nPtAcq = frequence * duree;

						// Initialisation de la zone de donnes du fichier au format sytmis
						pDonneesEv = new short[nPtAcq*m_nVoie];
						for (int l=0;l<nPtAcq;l++) pDonneesEv[l] = 0;

						int iPtAc = 0;
						// lecture des signaux
						while (!iss.eof())
						{
							iss >> point;
							pDonneesEv[iPtAc] = (short) (point/m_CfgScop.SensCarteAcq);
							iPtAc++;
						}

						pEnteteFichEv = new char[m_DimEnteteFichEv];
						if (!pEnteteFichEv) return FALSE;
						MajEnteteFichEv(pEnteteFichEv,m_DimEnteteFichEv,TRUE);


						// enregistrement 
						FILE *fsignal;
						if ((fsignal = fopen(LPCTSTR(cheminFichierSignal.c_str()),"w+b")) != NULL)
						{
							fwrite(pEnteteFichEv,SZCH,m_DimEnteteFichEv,fsignal);
							fwrite(pDonneesEv,SZSH,nPtAcq*m_nVoie,fsignal);
							fclose(fsignal);
							fsignal = NULL;
						}
					}
					ligneIndex++;
					PumpMessages();
					
					// j'ai essay les mthodes SetRange, SetPos, StepIt ... de ma classe ProgressCtrl
					// mais a n'a pas march, j'ai remplac par ces mthodes du coup 
					SendMessage(DlgProgress.m_progress, PBM_SETPOS, ligneIndex, 0);
					SendMessage(DlgProgress.m_progress, PBM_STEPIT, 0, 0); 
				}		
			}
			fsource.close();
		}
	}
	if (DlgProgress.DoModal() == IDCANCEL) {
		DlgImportEv.EndDialog();
	};
	return 0;			
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Fonction permettant de rafraichir l'cran pendant un traitement "gourmand"
// Cette mthode :  j'ai copi le code source de farscape
//
////////////////////////////////////////////////////////////////////////////////////////////////////

void CScop32Doc::PumpMessages() 
{ 
   // Handle dialog messages 
    MSG msg; 
    while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) 
    { 
        if (!AfxGetApp()->PreTranslateMessage(&msg)) 
		{ 
			::TranslateMessage(&msg); 
			::DispatchMessage(&msg); 
		}            
		AfxGetApp()->OnIdle(0);   // updates user interface 
		AfxGetApp()->OnIdle(1);   // frees temporary objects 
    } 
}